
(* any configuration of xbots and flyways - SetConfiguration, GetConfiguration. Configuration XML file 'PMCConfig.xml' must be in the root directory of the FileDevice *)
FUNCTION_BLOCK FileExample04_Configuration
	//read file from disk
	ReadFile(Execute := Execute,file_device := FileDevice,file_path := 'PMCConfig.xml',data_adr := ADR(send_config_array500000));
	
	//deactivate the PMC
	PMC_DeactivateXbots1(Execute := ReadFile.Done,PM_Controller := PM_Controller);
	
	//send the configuration to the PMC
	PMC_SetConfiguration1(Execute := PMC_DeactivateXbots1.Done,nBytes := ReadFile.file_size,Bytes := send_config_array500000,PM_Controller := PM_Controller);

	//reboot PMC to switch to the new configuration (restart PMT to update display in the GUI)
	PMC_Reboot1(Execute := PMC_SetConfiguration1.Done,PM_Controller := PM_Controller);

	//read the configuration from the PMC
	PMC_GetConfiguration1(Execute := PMC_Reboot1.Done,Bytes := read_config_array500000,PM_Controller := PM_Controller);

	Done := PMC_GetConfiguration1.Done;
END_FUNCTION_BLOCK
